<?php namespace App\Models;

use CodeIgniter\Model;

class TransactionModel extends Model
{
	protected $table      = 'transactions';
	protected $primaryKey = 'tid';

	protected $returnType = 'array';
	protected $useSoftDeletes = false;

	// this happens first, model removes all other fields from input data
	protected $allowedFields = [
		'customer_id', 'subscription_id', 'email_id', 'payment_id', 'active'
	];

	protected $useTimestamps = true;
	protected $createdField  = 'created_at';
	protected $updatedField  = 'updated_at';
	protected $dateFormat  	 = 'datetime';

	protected $validationRules = [];

	

	protected $validationMessages = [];

	protected $skipValidation = false;	

}
