<?php namespace App\Models;

use CodeIgniter\Model;

class MembershipModel extends Model
{
	protected $table      = 'membership_plan';
	protected $primaryKey = 'plan_id';

	protected $returnType = 'array';
	protected $useSoftDeletes = false;

	// this happens first, model removes all other fields from input data
	protected $allowedFields = [
		'plan_name', 'plan_type', 'plan_amount', 'plan_discount', 'plan_duration', 'plan_images', 'plan_videos', 
		'plan_offers', 'status'
	];

	protected $useTimestamps = true;
	protected $createdField  = 'created_at';
	protected $updatedField  = 'updated_at';
	protected $dateFormat  	 = 'datetime';

	protected $skipValidation = false;
    
}
