<?php namespace App\Models;

use CodeIgniter\Model;

class DocumentsModel extends Model
{
	protected $table      = 'documents';
	protected $primaryKey = 'doc_id';

	protected $returnType = 'array';
	protected $useSoftDeletes = false;

	// this happens first, model removes all other fields from input data
	protected $allowedFields = [
		'form_id', 'filename', 'filepath', 'form_type', 'upload_from', 'status'
	];

	protected $useTimestamps = true;
	protected $createdField  = 'created_at';
	protected $updatedField  = 'updated_at';
	protected $dateFormat  	 = 'datetime';

	protected $skipValidation = false;
    
}
