<?php

use Config\Services;

if (! function_exists('send_email_customer'))
{
    /** 
    * Builds an account activation HTML email from views and sends it.
    */
    function send_email_customer($to, $data)
    {
        // $to = "kannan2187@gmail.com";
        $subject = "Welcome to the glad2join.com Community!";
        $htmlContent = " 
        <html> 
        <head> 
            <title>Welcome to the glad2join.com Community!</title> 
        </head> 
        <body> 
            <p><strong> Dear ".$data['name'].",</strong></p> 
            <p>We're thrilled to welcome you to the glad2join.com community!</p>
        </body> 
        </html>";
        // <p>Thank you, your payment success. Our admin team will check and get back to you within 24 hours.</p>
    	// Set content-type header for sending HTML email 
    	// $headers = 'From: welcome@ecologienationale.fr' . "\r\n";
    	$headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        //	$headers .= 'Cc: iamjamesstephan@gmail.com' . "\r\n";
    	// $headers .= 'Cc: pradeepavm@gmail.com' . "\r\n";
    	// $headers .= 'Bcc: techjam1993@gmail.com' . "\r\n";
    	// Additional headers 
    
    
    	$m = mail($to, $subject, $htmlContent, $headers, "-f info@glad2join.com");
    
    	// Set content-type header for sending HTML email
    
    	if (!$m) {
    		// echo 'Message could not be sent.';
    	} else {
    		// echo 'Message has been sent';
    		// $result = 'One of our representative will get in touch you.';
    	}
		 // the message
		
		// die;
    }
}

if (! function_exists('send_email_customer_resetpwd'))
{
    /**
    * Builds an account activation HTML email from views and sends it.
    */
    function send_email_customer_resetpwd($to, $password)
    {
		 // the message
		 
		$subject = "Vous avez réussi à réinitialiser le mot de passe de votre compte Groupe Ecologie Nationale.";
        $htmlContent = " 
        <html> 
        <head> 
            <title>Vous avez réussi à réinitialiser le mot de passe de votre compte Groupe Ecologie Nationale.</title> 
        </head> 
        <body> 
            <h1>Bonjour,</h1> 
            <p>Bienvenue chez Groupe Ecologie Nationale ! Merci de vous être inscrit. Vos données de connexion sont les suivantes :</p>
            <table cellspacing='0' style='border: 2px dashed #FB4314; width: 100%;'> 
                <tr> 
                    <th>Nom d'utilisateur :</th><td>" .$to. "</td> 
                </tr> 
                <tr style='background-color: #e0e0e0;'> 
                    <th>Mot de passe :</th><td>" . $password . "</td> 
                </tr>
            </table> 
            <p>Vous avez réussi à réinitialiser le mot de passe de votre compte Groupe Ecologie Nationale. Vous pouvez vous connecter à votre compte Groupe Ecologie Nationale avec votre nouveau mot de passe.</p>
            <p>Nous vous remercions et vous prions d'agréer, Madame, Monsieur, l'expression de nos salutations distinguées,</p>
            <p>L'équipe Groupe Ecologie Nationale.</p>
        </body> 
        </html>";
    
    	// Set content-type header for sending HTML email 
    	$headers = "MIME-Version: 1.0" . "\r\n";
    	$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    	 $headers .= 'From:welcome@ecologienationale.fr' . "\r\n";
    	// $headers .= 'Cc: iamjamesstephan@gmail.com' . "\r\n";
    	// $headers .= 'Cc: pradeepavm@gmail.com' . "\r\n";
    	// $headers .= 'Bcc: techjam1993@gmail.com' . "\r\n";
    	// Additional headers 
    
    
    	$m = mail($to, $subject, $htmlContent, $headers);
    
    	// Set content-type header for sending HTML email
    
    	if (!$m) {
    		// echo 'Message could not be sent.';
    	} else {
    		// echo 'Message has been sent';
    		// $result = 'One of our representative will get in touch you.';
    	}
    	
		/* $to = "kannan2187@gmail.com";
        $subject = "Welcome to Groupe Ecologie Nationale";
         
		$message = "<b>This is HTML message.</b>";
		$message .= "<h1>This is headline.</h1>";

		$header = "From:welcome@ecologienationale.fr \r\n";
		$header .= "Cc:james@akkenna.com \r\n";
		$header .= "MIME-Version: 1.0\r\n";
		$header .= "Content-type: text/html\r\n";

		$retval = mail ($to,$subject,$message,$header);

		if( $retval == true ) {
		// echo "Message sent successfully...";
		}else {
	// 	echo "Message could not be sent...";
		} */
    }
}

/* if (! function_exists('send_email_customer'))
{   
    function send_email_customer($to, $data)
    {
		 // the message
		$to = "kannan2187@gmail.com";
        $subject = "Welcome to Groupe Ecologie Nationale";
         
		$message = "<b>This is HTML message.</b>";
		$message .= "<h1>This is headline.</h1>";

		$header = "From:kumar@bellenergy.fr \r\n";
		$header .= "Cc:james@akkenna.com \r\n";
		$header .= "MIME-Version: 1.0\r\n";
		$header .= "Content-type: text/html\r\n";

		$retval = mail ($to,$subject,$message,$header);

		if( $retval == true ) {
		echo "Message sent successfully...";
		}else {
		echo "Message could not be sent...";
		}
    }
} */


if (! function_exists('randomPassword'))
{
    /**
    * Builds an randomPassword and sends it.
    */
    function randomPassword() {
		$alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		$pass = array(); //remember to declare $pass as an array
		$alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
		for ($i = 0; $i < 8; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		return implode($pass); //turn the array into a string
	}
}

if (! function_exists('send_activation_email'))
{
    /**
    * Builds an account activation HTML email from views and sends it.
    */
    function send_activation_email($to, $activateHash)
    {
		// echo lang('Auth.registration'); die;
    	$htmlMessage = view('emails\header');
    	$htmlMessage .= view('mails\activation', ['hash' => $activateHash]);
    	$htmlMessage .= view('emails\footer');

    	$email = \Config\Services::email();
		$email->initialize([
			'mailType' => 'html'
		]);
		// echo $htmlMessage; die;
    	$email->setTo($to);
        $email->setSubject(lang('Auth.registration'));
		$email->setMessage($htmlMessage);

        return $email->send();
    }
}

if (! function_exists('send_confirmation_email'))
{
    /**
    * Builds an email confirmation HTML email from views and sends it.
    */
    function send_confirmation_email($to, $activateHash)
    {
        $htmlMessage = view('Views\emails\header');
        $htmlMessage .= view('Views\emails\confirmation', ['hash' => $activateHash]);
        $htmlMessage .= view('Views\emails\footer');

        $email = \Config\Services::email();
        $email->initialize([
            'mailType' => 'html'
        ]);

        $email->setTo($to);
        $email->setSubject(lang('Auth.confirmEmail'));
        $email->setMessage($htmlMessage);

        return $email->send();
    }
}


if (! function_exists('send_notification_email'))
{
    /**
    * Builds a notification HTML email about email address change from views and sends it.
    */
    function send_notification_email($to)
    {
        $htmlMessage = view('Views\emails\header');
        $htmlMessage .= view('Views\emails\notification');
        $htmlMessage .= view('Views\emails\footer');

        $email = \Config\Services::email();
        $email->initialize([
            'mailType' => 'html'
        ]);

        $email->setTo($to);
        $email->setSubject(lang('Auth.emailUpdateRequest'));
        $email->setMessage($htmlMessage);

        return $email->send();
    }
}


if (! function_exists('send_password_reset_email'))
{
    /**
    * Builds a password reset HTML email from views and sends it.
    */
    function send_password_reset_email($to, $resetHash)
    {
        $htmlMessage = view('Views\emails\header');
        $htmlMessage .= view('Views\emails\reset', ['hash' => $resetHash]);
        $htmlMessage .= view('Views\emails\footer');

        $email = \Config\Services::email();
        $email->initialize([
            'mailType' => 'html'
        ]);

        $email->setTo($to);
        $email->setSubject(lang('Auth.passwordResetRequest'));
        $email->setMessage($htmlMessage);

        return $email->send();
    }
}

if (! function_exists('send_otp_customer_email'))
{
/** 
    * Builds an account activation HTML email from views and sends it.
    */
    function send_otp_customer_email($to, $data)
    {
        // $to = "kannan2187@gmail.com";
        $subject = "Welcome to G2J! your OTP is ".$data['otp'];
        $htmlContent = " 
        <html> 
        <head> 
            <title>Welcome to G2J!</title> 
        </head> 
        <body> 
            <h1>Dear ".$data['name'].",</h1> 
            <p>Your OPT is ".$data['otp']."</p>
            
        </body> 
        </html>";
    
    	// Set content-type header for sending HTML email 
    	// $headers = 'From: welcome@ecologienationale.fr' . "\r\n";
    	$headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        //	$headers .= 'Cc: iamjamesstephan@gmail.com' . "\r\n";
    	// $headers .= 'Cc: pradeepavm@gmail.com' . "\r\n";
    	// $headers .= 'Bcc: techjam1993@gmail.com' . "\r\n";
    	// Additional headers 
    
    
    	$m = @mail($to, $subject, $htmlContent, $headers, "-f info@glad2join.com");
    // echo $m; die;
    	// Set content-type header for sending HTML email
    
    	if (!$m) {
    		// echo 'Message could not be sent.';
    	} else {
    		// echo 'Message has been sent';
    		// $result = 'One of our representative will get in touch you.';
    	}
		 // the message
		
		// die;
    }
}
