<?php
namespace App\Controllers;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 *
 * @package CodeIgniter
 */

use CodeIgniter\Controller;

class BaseController extends Controller
{

	/**
	 * An array of helpers to be loaded automatically upon
	 * class instantiation. These helpers will be available
	 * to all other controllers that extend BaseController.
	 *
	 * @var array
	 */
	protected $helpers = [];

	/**
	 * Constructor.
	 */
	public function initController(\CodeIgniter\HTTP\RequestInterface $request, \CodeIgniter\HTTP\ResponseInterface $response, \Psr\Log\LoggerInterface $logger)
	{
		// Do Not Edit This Line
		parent::initController($request, $response, $logger);

		//--------------------------------------------------------------------
		// Preload any models, libraries, etc, here.
		//--------------------------------------------------------------------
		// E.g.:
		// $this->session = \Config\Services::session();
	}
	
	public function admin_template(string $page, array $data)
    {
        // echo view('admin/layouts/header', $data);
        echo view($page, $data);
       // echo view('admin/layouts/footer', $data);
    } 
	
	public function template(string $page, array $data)
    {
		$router = service('router'); 
		$action  = $router->methodName();		
		echo view('themes/default/layout/header', $data);
		echo view($page, $data);
		echo view('themes/default/layout/footer', $data);
		
    } 
		
    function data_serialize($data)
    {
        return serialize($data);
    }

    function data_unserialize($data)
    {
        return unserialize($data);
    }
	
	function upload_file($path = '', $new_filename = '', $postFile = '') {
		
		$files = $this->request->getFile($postFile);
		$files->move(WRITEPATH . 'uploads/'. $path .'/', $new_filename);		
		return $files;
		// print_r($files); die;
        /* $config['upload_path'] = './writable/uploads/' . $path .'/';
        $config['allowed_types'] = 'pdf|jpg|png|jpeg';
       // $config['max_size'] = 500000;
		$config['file_name'] = $new_filename;
		$config['overwrite']=False;
		
        $this->load->library('upload', $config);
        // print_r($_FILES[$postFile]['size']); die;
        if (!$this->upload->do_upload($postFile)) {
            $error = array('error' => $this->upload->display_errors());
			return $error;
        } else {
            $data = array('image_metadata' => $this->upload->data());
			// print_r($data); 
			if( !empty($_FILES[$postFile]['size']) && $_FILES[$postFile]['size'] > 2097152){
				$fileName = $data['image_metadata']['file_name'];
				// resizeImage($path, $fileName);				
			}
			return $data;
        } */
    }


}
