<?php
namespace App\Controllers\Auth;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use App\Models\UserModel;
use App\Models\CustomerModel;

class RegistrationController extends Controller
{
	/**
	 * Access to current session.
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Authentication settings.
	 */
	protected $config;


    //--------------------------------------------------------------------

	public function __construct()
	{
		// start session
		$this->session = Services::session();
		helper('auth');
	}

    //--------------------------------------------------------------------

	/**
	 * Displays register form.
	 */
	public function register()
	{
		if ($this->session->isLoggedIn) {
			return redirect()->to('account');
		}

		return view('front_end/auth/register');
	}

    //--------------------------------------------------------------------

	/**
	 * Attempt to register a new user.
	 */
	public function attemptRegister()
	{
		$postFdata = array_filter($this->request->getPost());
		$page_data['postFdata'] = array_filter($this->request->getPost());
		
		// print_r($sessionpost); die;
		if( !empty($postFdata) && ( isset($postFdata['creation']) && $postFdata['creation'] == 'submit') ){ 
			// print_r($sessionpost); die;
			helper('text');
			$password = randomPassword(); // "demo123"; //rand();
			// save new customer, validation happens in the model
			$customer = new CustomerModel();
			// $getRule = $customer->getRule('registration');
			// $customer->setValidationRules($getRule);
			
			$rowdata = $customer->where('email', $this->request->getPost('email'))->first();
			
			if( empty($rowdata) ){
				$data = [
				'firstname'          	=> $this->request->getPost('firstname'),
				'lastname'          	=> $this->request->getPost('lastname'),
				'email'         	=> $this->request->getPost('email'),
				'phone'     		=> $this->request->getPost('phone'),
				'civility'     		=> $this->request->getPost('civility'),
				'terms_agree'     	=> $this->request->getPost('terms_agree'),
				'address'     	=> !empty($solarRow['address']) ? $solarRow['address'] : '',
				'password'     		=> $password,
				'activate_hash' 	=> random_string('alnum', 32)
				];

				if (! $customer->save($data)) {
					return redirect()->back()->withInput()->with('errors', $customer->errors());
				}
				// helper('auth'); 
				// send_activation_email($data['email'], $data['activate_hash']);
				send_email_customer($data['email'], $data);
				// success
				// return redirect()->to(site_url('connexion'))->with('success', lang('Auth.registrationSuccess'));
				return redirect()->to('connexion')->with('success', lang('Auth.registrationSuccess'));
				// echo 'sdsd'; die;
			}else{	
				// $this->session->remove(['sessionpost']);	
				$page_data['customer'] = $rowdata;
				// return redirect()->to('register')->with('error', lang('Auth.accountAlreadyExists'));
				return redirect()->to('register')->with('error', lang('Auth.accountAlreadyExists'));
				// print_r($rowdata); die;
			}				
		}	
			
		/* helper('text');

		// save new user, validation happens in the model
		$users = new UserModel();
		$getRule = $users->getRule('registration');
		$users->setValidationRules($getRule);
		
        $user = [
            'firstname'          	=> $this->request->getPost('firstname'),
            'lastname'          	=> $this->request->getPost('lastname'),
            'name'          	=> $this->request->getPost('name'),
            'email'         	=> $this->request->getPost('email'),
            'password'     		=> $this->request->getPost('password'),
            'password_confirm'	=> $this->request->getPost('password_confirm'),
            'activate_hash' 	=> random_string('alnum', 32)
        ];

        if (! $users->save($user)) {
			return redirect()->back()->withInput()->with('errors', $users->errors());
        }

		// send activation email //
		// send email activation is commented no email support //
		
		// helper('auth'); 
        // send_activation_email($user['email'], $user['activate_hash']);

		// success
        return redirect()->to('login')->with('success', lang('Auth.registrationSuccess')); */ 
	}

    //--------------------------------------------------------------------

	/**
	 * Activate account.
	 */
	public function activateAccount()
	{
		$users = new UserModel();

		// check token
		$user = $users->where('activate_hash', $this->request->getGet('token'))
			->where('active', 0)
			->first();

		// check user if exists
		if (is_null($user)) {
			return redirect()->to('login')->with('error', lang('Auth.activationNoUser'));
		}

		// update user account to active
		$updatedUser['id'] = $user['id'];
		$updatedUser['active'] = 1;
		$users->save($updatedUser);

		return redirect()->to('login')->with('success', lang('Auth.activationSuccess'));
	}

}
