<?php
namespace App\Controllers\Auth;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use App\Models\UserModel;
use App\Models\CustomerModel;
use App\Models\DocumentsModel;
use App\Models\MembershipModel;
use App\Models\TransactionModel;

class AccountController extends Controller
{

	/**
	 * Access to current session.
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Authentication settings.
	 */
	protected $config;


    //--------------------------------------------------------------------

	public function __construct()
	{
		// start session
		$this->session = Services::session();
		$this->customers = new CustomerModel();	
		$this->documents = new DocumentsModel();
		$this->mship = new MembershipModel();
		$this->trans = new TransactionModel();
	}

    //--------------------------------------------------------------------

	/**
	 * Displays account settings.
	 */
	public function account()
	{
		if (! $this->session->isAdminLoggedIn) {
			return redirect()->to('login');
		}
		
		$db      = \Config\Database::connect();
		$trans = $db->table('transactions');
					// $trans->where('transactions.customer_id', $customer_id);
					// $trans->where('transactions.active', '1');
					$trans->select('transactions.*, membership_plan.*, customer.name, customer.email, customer.phone,');
					$trans->join('customer', 'customer.customer_id = transactions.customer_id', 'left');
					$trans->join('membership_plan', 'membership_plan.plan_id = transactions.subscription_id', 'left');
		$queryDoc   = $trans->get();  // Produces: SELECT * FROM mytable
		$records = $queryDoc->getResultArray();

		
		// count all active trans
		$tactive_counts = $this->trans->where('active', 1)->countAllResults();
		// count all active trans
		$tdactive_counts = $this->trans->where('active', 0)->countAllResults(); 

		// count all active customer
		$cactive_counts = $this->customers->where('active', 1)->countAllResults(); 

		// count all active customer
		$cdactive_counts = $this->customers->where('active', 0)->countAllResults();
				
		// return redirect()->to('admin/dashboard');
		return view('auth/starter', [
			'userData' => $this->session->userData,
			'pageTitle' => 'Dashboard',
			'tactive_counts' => $tactive_counts,
			'tdactive_counts' => $tdactive_counts,
			'cactive_counts' => $cactive_counts,
			'cdactive_counts' => $cdactive_counts,
			'records' => $records,
		]);
	}
	
	public function myaccount()
	{
		if (! $this->session->isAdminLoggedIn) {
			return redirect()->to('login');
		}

		$page_data['pageTitle'] = 'My Account'; 

		return view('auth/myaccount',[
			'userData' => $this->session->userData,
			'pageTitle' => 'My Account',
		]);
	}
	
	public function uploadfile()
	{
		if (! $this->session->isAdminLoggedIn) {
			return redirect()->to('login');
		}

		return view('auth/uploadfile', [
			'userData' => $this->session->userData,
		]);
	}
	
	public function downloadfile()
	{
		if (! $this->session->isAdminLoggedIn) {
			return redirect()->to('login');
		}

		return view('auth/downloadfile', [
			'userData' => $this->session->userData,
		]);
	}
	
	public function contact()
	{
		if (! $this->session->isAdminLoggedIn) {
			return redirect()->to('login');
		}

		return view('auth/contact', [
			'userData' => $this->session->userData,
		]);
	}

	//--------------------------------------------------------------------

	/**
	 * Displays profile page.
	 */
	public function profile()
	{
		if (! $this->session->isAdminLoggedIn) {
			return redirect()->to('login');
		}

		return view('auth/profile', [
			'userData' => $this->session->userData,
			'pageTitle' => 'Profile',
		]);
	}
	
	//--------------------------------------------------------------------

	/**
	 * Updates regular account settings.
	 */
	public function updateProfile()
	{
		// update user, validation happens in model
		$users = new UserModel();
		$getRule = $users->getRule('updateProfile');
		$users->setValidationRules($getRule);

		$user = [
			'id'  	=> $this->session->get('userData.id'),
			'name' 	=> $this->request->getPost('name'),
			'firstname' 	=> $this->request->getPost('firstname'),
			'lastname' 	=> $this->request->getPost('lastname'),
			'email' 	=> $this->request->getPost('email')
		];

		if (! $users->save($user)) {
			return redirect()->back()->withInput()->with('errors', $users->errors());
        }

        // update session data
        $this->session->push('userData', $user);

        return redirect()->to('profile')->with('success', lang('Auth.updateSuccess'));
	}

    //--------------------------------------------------------------------

	/**
	 * Updates regular account settings.
	 */
	public function updateAccount()
	{
		// update user, validation happens in model
		$users = new UserModel();
		$getRule = $users->getRule('updateAccount');
		$users->setValidationRules($getRule);

		$user = [
			'id'  	=> $this->session->get('userData.id'),
			'name' 	=> $this->request->getPost('name')
		];

		if (! $users->save($user)) {
			return redirect()->back()->withInput()->with('errors', $users->errors());
        }

        // update session data
        $this->session->push('userData', $user);

        return redirect()->to('account')->with('success', lang('Auth.updateSuccess'));
	}

    //--------------------------------------------------------------------

	/**
	 * Handles password change.
	 */
	public function changePassword()
	{
		// validate request
		$rules = [
			'password' 	=> 'required|min_length[5]',
			'new_password' => 'required|min_length[5]',
			'new_password_confirm' => 'required|matches[new_password]'
		];

		if (! $this->validate($rules)) {
			return redirect()->to('profile')->withInput()
				->with('errors', $this->validator->getErrors());
		}

		// check current password
		$users = new UserModel();

		$user = $users->find($this->session->get('userData.id'));

		if (
			! $user ||
			! password_verify($this->request->getPost('password'), $user['password_hash'])
		) {
			return redirect()->to('profile')->withInput()->with('error', lang('Auth.wrongCredentials'));
		}

		// update user's password
		$updatedUser['id'] = $this->session->get('userData.id');

		$updatedUser['password'] = $this->request->getPost('new_password');

		$users->save($updatedUser);

		// redirect to account with success message
		return redirect()->to('profile')->with('success', lang('Auth.passwordUpdateSuccess'));
	}

    //--------------------------------------------------------------------

	/**
	 * Deletes user account.
	 */
	public function deleteAccount()
	{
		// check current password
		$users = new UserModel();
		
		$user = $users->find($this->session->get('userData.id'));

		if (
			! $user ||
			! password_verify($this->request->getPost('password'), $user['password_hash'])
		) {
			return redirect()->back()->withInput()->with('error', lang('Auth.wrongCredentials'));
		}

		// delete account from DB
		$users->delete($this->session->get('userData.id'));

		// log out user
		$this->session->remove(['isLoggedIn', 'userData']);

		// redirect to register with success message
		return redirect()->to('register')->with('success', lang('Auth.accountDeleted'));
	}

}
