<?php

namespace App\Controllers;
use Config\Email;
use Config\Services;

class Ajax extends BaseController
{
	/**
	 * Access to current session.
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Authentication settings.
	 */
	protected $config;
	
	public function __construct()
    {
        $this->request = \Config\Services::request();
        // start session
		$this->session = Services::session();
		helper('auth');
		// helper('user_agent');
		
		header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . ' GMT');
		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: post-check=0, pre-check=0');
		header('Pragma: no-cache');
		
    }
	
    public function index($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Home';
		$postFdata = array_filter($this->request->getPost());
		// print_r($postFdata);
		$this->template("themes/default/popup",$page_data);
    }		
}
